/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class RagManDiscardEffect
extends OneShotEffect {
    RagManDiscardEffect() {
        super(Outcome.Discard);
        this.staticText = "and discards a creature card at random";
    }

    private RagManDiscardEffect(RagManDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public RagManDiscardEffect copy() {
        return new RagManDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            CardsImpl creatureCardsInHand = new CardsImpl();
            for (UUID cardId : player.getHand()) {
                Card card = player.getHand().get(cardId, game);
                if (!StaticFilters.FILTER_CARD_CREATURE.match(card, game)) continue;
                creatureCardsInHand.add(card);
            }
            if (!creatureCardsInHand.isEmpty()) {
                Card card = creatureCardsInHand.getRandom(game);
                player.discard(card, false, source, game);
            }
            return true;
        }
        return false;
    }
}

