/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RaidBombardmentTriggeredAbility
extends TriggeredAbilityImpl {
    public RaidBombardmentTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1));
    }

    private RaidBombardmentTriggeredAbility(RaidBombardmentTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RaidBombardmentTriggeredAbility copy() {
        return new RaidBombardmentTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attacker;
        if (game.isActivePlayer(this.controllerId) && (attacker = game.getPermanent(event.getSourceId())) != null && attacker.getPower().getValue() <= 2) {
            UUID defendingPlayerId = game.getCombat().getDefenderId(attacker.getId());
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(defendingPlayerId));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control with power 2 or less attacks, {this} deals 1 damage to the player or planeswalker that creature is attacking.";
    }
}

