/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RainOfDaggersEffect
extends OneShotEffect {
    RainOfDaggersEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures target opponent controls. You lose 2 life for each creature destroyed this way";
    }

    private RainOfDaggersEffect(RainOfDaggersEffect effect) {
        super((OneShotEffect)effect);
    }

    public RainOfDaggersEffect copy() {
        return new RainOfDaggersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && this.getTargetPointer().getFirst(game, source) != null) {
            int destroyedCreature = 0;
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, this.getTargetPointer().getFirst(game, source), game)) {
                if (!permanent.destroy(source, game, false)) continue;
                ++destroyedCreature;
            }
            if (destroyedCreature > 0) {
                game.processAction();
                new LoseLifeSourceControllerEffect(destroyedCreature * 2).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

