/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.discard.DiscardTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RakdossReturnEffect
extends OneShotEffect {
    RakdossReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "That player or that planeswalker's controller discards X cards.";
    }

    private RakdossReturnEffect(RakdossReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public RakdossReturnEffect copy() {
        return new RakdossReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        DiscardTargetEffect effect = new DiscardTargetEffect((DynamicValue)GetXValue.instance);
        effect.setTargetPointer((TargetPointer)new FixedTarget(player.getId(), game));
        return effect.apply(game, source);
    }
}

