/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageControllerEffect;
import mage.abilities.effects.common.ExileAndReturnSourceEffect;
import mage.constants.Outcome;
import mage.constants.Pronoun;
import mage.constants.PutCards;
import mage.game.Game;
import mage.players.Player;

class RalMonsoonMageEffect
extends OneShotEffect {
    RalMonsoonMageEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin. If you lose the flip, {this} deals 1 damage to you. If you win the flip, you may exile {this}. If you do, return him to the battlefield transformed under his owner's control";
    }

    private RalMonsoonMageEffect(RalMonsoonMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public RalMonsoonMageEffect copy() {
        return new RalMonsoonMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        boolean wonFlip = player.flipCoin(source, game, true);
        if (wonFlip) {
            if (player.chooseUse(this.outcome, "Exile {this} and return transformed?", source, game)) {
                new ExileAndReturnSourceEffect(PutCards.BATTLEFIELD_TRANSFORMED, Pronoun.HE).apply(game, source);
            }
        } else {
            new DamageControllerEffect(1).apply(game, source);
        }
        return true;
    }
}

