/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.other.AnotherTargetPredicate;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetpointer.SecondTargetPointer;
import mage.target.targetpointer.TargetPointer;

public final class RallyManeuver
extends CardImpl {
    private static final FilterCreaturePermanent filter2 = new FilterCreaturePermanent("other creature");

    public RallyManeuver(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{W}");
        this.getSpellAbility().addTarget(new TargetCreaturePermanent().setTargetTag(1).withChooseHint("+2/+0 and first strike"));
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(2, 0).setText("Target creature gets +2/+0"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn, "and gains first strike until end of turn"));
        this.getSpellAbility().addTarget(new TargetPermanent(0, 1, (FilterPermanent)filter2).setTargetTag(2).withChooseHint("+0/+2 and lifelink"));
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(0, 2).setText("Up to one other target creature gets +0/+2").setTargetPointer((TargetPointer)new SecondTargetPointer()));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn, "and gains lifelink until end of turn").setTargetPointer((TargetPointer)new SecondTargetPointer()));
    }

    private RallyManeuver(RallyManeuver card) {
        super((CardImpl)card);
    }

    public RallyManeuver copy() {
        return new RallyManeuver(this);
    }

    static {
        filter2.add((ObjectSourcePlayerPredicate)new AnotherTargetPredicate(2));
    }
}

