/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.RedWarriorToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class RallyTheHordeEffect
extends OneShotEffect {
    RallyTheHordeEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile the top card of your library. Exile the top card of your library. Exile the top card of your library. If the last card exiled isn't a land card, repeat this process. Create a 1/1 red Warrior creature token for each nonland card exiled this way.";
    }

    private RallyTheHordeEffect(RallyTheHordeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RallyTheHordeEffect copy() {
        return new RallyTheHordeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int nonLandCardsExiled = 0;
            while (controller.getLibrary().hasCards()) {
                nonLandCardsExiled += this.checkIfNextLibCardIsNonLandAndExile(controller, source, game);
                if (controller.getLibrary().hasCards()) {
                    nonLandCardsExiled += this.checkIfNextLibCardIsNonLandAndExile(controller, source, game);
                }
                if (!controller.getLibrary().hasCards()) continue;
                int nonLands = this.checkIfNextLibCardIsNonLandAndExile(controller, source, game);
                if (nonLands == 0) break;
                nonLandCardsExiled += nonLands;
            }
            return new CreateTokenEffect((Token)new RedWarriorToken(), nonLandCardsExiled).apply(game, source);
        }
        return false;
    }

    private int checkIfNextLibCardIsNonLandAndExile(Player controller, Ability source, Game game) {
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.LIBRARY, true);
            return card.isLand(game) ? 0 : 1;
        }
        return 0;
    }
}

