/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class RamThroughEffect
extends OneShotEffect {
    RamThroughEffect() {
        super(Outcome.Benefit);
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
        this.staticText = "Target creature you control deals damage equal to its power to target creature you don't control. If the creature you control has trample, excess damage is dealt to that creature's controller instead.";
    }

    private RamThroughEffect(RamThroughEffect effect) {
        super((OneShotEffect)effect);
    }

    public RamThroughEffect copy() {
        return new RamThroughEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.size() < 2) {
            return false;
        }
        Permanent permanent = (Permanent)permanents.get(0);
        int power = permanent.getPower().getValue();
        if (power < 1) {
            return false;
        }
        Permanent creature = (Permanent)permanents.get(1);
        if (!permanent.hasAbility((Ability)TrampleAbility.getInstance(), game)) {
            return creature.damage(power, permanent.getId(), source, game) > 0;
        }
        int excess = creature.damageWithExcess(power, permanent.getId(), source, game);
        if (excess > 0) {
            Optional.ofNullable(creature).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.damage(excess, permanent.getId(), source, game));
        }
        return true;
    }
}

