/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RamirezDePietroPillagerEffect
extends OneShotEffect {
    RamirezDePietroPillagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of that player's library. You may cast that card for as long as it remains exiled.";
    }

    private RamirezDePietroPillagerEffect(RamirezDePietroPillagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RamirezDePietroPillagerEffect copy() {
        return new RamirezDePietroPillagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.Custom, (boolean)false, (UUID)source.getControllerId(), null);
        return true;
    }
}

