/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RampagingAetherhoodEffect
extends OneShotEffect {
    public RampagingAetherhoodEffect() {
        super(Outcome.Benefit);
        this.staticText = "you get an amount of {E} equal to this creature's power. Then you may pay one or more {E}. If you do, put that many +1/+1 counters on this creature.";
    }

    public RampagingAetherhoodEffect(RampagingAetherhoodEffect effect) {
        super((OneShotEffect)effect);
    }

    public RampagingAetherhoodEffect copy() {
        return new RampagingAetherhoodEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int energyToPay;
        PayEnergyCost cost;
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent == null || controller == null) {
            return false;
        }
        int amount = permanent.getPower().getValue();
        controller.addCounters(CounterType.ENERGY.createInstance(amount), source.getControllerId(), source, game);
        int totalEnergy = controller.getCountersCount(CounterType.ENERGY);
        if (totalEnergy > 0 && controller.chooseUse(Outcome.Benefit, "Pay one or more {E}? Put that many +1/+1 counters on this creature", source, game) && (cost = new PayEnergyCost(energyToPay = controller.getAmount(1, totalEnergy, "Pay one or more {E}", source, game))).pay(source, game, source, controller.getId(), true)) {
            new AddCountersSourceEffect(CounterType.P1P1.createInstance(energyToPay), true).apply(game, source);
            return true;
        }
        return false;
    }
}

