/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.CardsInControllerGraveyardCondition;
import mage.abilities.effects.WhileConditionContinuousEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RamunapHydraBoostEffect
extends WhileConditionContinuousEffect {
    private static final FilterCard filter = new FilterCard("a Desert");
    private final int power;
    private final int toughness;

    public RamunapHydraBoostEffect(int power, int toughness) {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, (Condition)new CardsInControllerGraveyardCondition(1, filter), Outcome.BoostCreature);
        this.power = power;
        this.toughness = toughness;
        this.staticText = "{this} gets +1/+1 as long as there is a Desert card in your graveyard";
    }

    private RamunapHydraBoostEffect(RamunapHydraBoostEffect effect) {
        super((WhileConditionContinuousEffect)effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    public RamunapHydraBoostEffect copy() {
        return new RamunapHydraBoostEffect(this);
    }

    public boolean applyEffect(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent != null) {
            permanent.addPower(this.power);
            permanent.addToughness(this.toughness);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.DESERT.getPredicate());
    }
}

