/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.Ownerable;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.game.permanent.token.Token;

class RanarTheEverWatchfulTriggeredAbility
extends TriggeredAbilityImpl {
    RanarTheEverWatchfulTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new SpiritWhiteToken()), false);
    }

    private RanarTheEverWatchfulTriggeredAbility(RanarTheEverWatchfulTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RanarTheEverWatchfulTriggeredAbility copy() {
        return new RanarTheEverWatchfulTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        int numberExiled = zEvent.getCards().size() + zEvent.getTokens().size();
        if (zEvent.getToZone() != Zone.EXILED || numberExiled == 0) {
            return false;
        }
        switch (zEvent.getFromZone()) {
            case BATTLEFIELD: {
                return zEvent.getSource() != null && this.controllerId.equals(zEvent.getSource().getControllerId()) && numberExiled > 0;
            }
            case HAND: {
                return zEvent.getCards().stream().filter(Objects::nonNull).map(Ownerable::getOwnerId).anyMatch(arg_0 -> ((RanarTheEverWatchfulTriggeredAbility)this).isControlledBy(arg_0));
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more cards are put into exile from your hand or a spell or ability you control exiles one or more permanents from the battlefield, create a 1/1 white Spirit creature token with flying.";
    }
}

