/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.r.RareBGonePredicate;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RareBGoneEffect
extends OneShotEffect {
    private static final FilterPermanent filterPermanent = new FilterPermanent();
    private static final FilterCard filterCard = new FilterCard();

    RareBGoneEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player sacrifices all permanents that are rare or mythic rare, then each player reveals their hand and discards all cards that are rare or mythic rare";
    }

    private RareBGoneEffect(RareBGoneEffect effect) {
        super((OneShotEffect)effect);
    }

    public RareBGoneEffect copy() {
        return new RareBGoneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) {
                // empty if block
            }
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(filterPermanent, playerId, game)) {
                permanent.sacrifice(source, game);
            }
            game.processAction();
            Cards cards = player.getHand();
            player.revealCards(source, cards, game);
            player.discard((Cards)new CardsImpl(cards.getCards(filterCard, game)), false, source, game);
        }
        return true;
    }

    static {
        filterPermanent.add((Predicate)RareBGonePredicate.instance);
        filterCard.add((Predicate)RareBGonePredicate.instance);
    }
}

