/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RashmiAndRagavanEffect
extends OneShotEffect {
    RashmiAndRagavanEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "exile the top card of target opponent's library and create a Treasure token. Then you may cast the exiled card without paying its mana cost if it's a spell with mana value less than the number of artifacts you control. If you don't cast it this way, you may cast it this turn";
    }

    private RashmiAndRagavanEffect(RashmiAndRagavanEffect effect) {
        super((OneShotEffect)effect);
    }

    public RashmiAndRagavanEffect copy() {
        return new RashmiAndRagavanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        MageObject sourceObject = source.getSourceObject(game);
        UUID exileId = CardUtil.getExileZoneId((String)(controller.getId().toString() + "-" + game.getState().getTurnNum() + "-" + sourceObject.getIdName()), (Game)game);
        String exileName = sourceObject.getIdName() + " play on turn " + game.getState().getTurnNum() + " for " + controller.getName();
        game.getExile().createZone(exileId, exileName).setCleanupOnEndTurn(true);
        HashSet<Card> cards = new HashSet<Card>();
        cards.add(card);
        if (card == null || !controller.moveCardsToExile(cards, source, game, true, exileId, exileName)) {
            return false;
        }
        int artifactCount = new PermanentsOnBattlefieldCount((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT).calculate(game, source, (Effect)this);
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, artifactCount));
        boolean cardWasCast = CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl(card), (FilterCard)filter);
        if (!cardWasCast) {
            PlayFromNotOwnHandZoneTargetEffect effect = new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, false, true);
            effect.setTargetPointer((TargetPointer)new FixedTargets(cards, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

