/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class RasputinDreamweaverWatcher
extends Watcher {
    private static final FilterPermanent filter = new FilterPermanent();
    private final Set<UUID> startedUntapped = new HashSet<UUID>();

    RasputinDreamweaverWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BEGINNING_PHASE_PRE) {
            game.getBattlefield().getAllActivePermanents(filter, game).forEach(permanent -> this.startedUntapped.add(permanent.getId()));
        }
    }

    public void reset() {
        this.startedUntapped.clear();
        super.reset();
    }

    public boolean startedUntapped(UUID cardId) {
        return this.startedUntapped.contains(cardId);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

