/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class RatonhnhaketonReturnEffect
extends OneShotEffect {
    private final UUID tokenId;

    RatonhnhaketonReturnEffect(UUID tokenId) {
        super(Outcome.Benefit);
        this.staticText = "return target Equipment card from your graveyard to the battlefield, then attach it to that token";
        this.tokenId = tokenId;
    }

    private RatonhnhaketonReturnEffect(RatonhnhaketonReturnEffect effect) {
        super((OneShotEffect)effect);
        this.tokenId = effect.tokenId;
    }

    public RatonhnhaketonReturnEffect copy() {
        return new RatonhnhaketonReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        Optional.ofNullable(this.tokenId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(p -> p.addAttachment(permanent.getId(), source, game));
        return true;
    }
}

