/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.r.RatonhnhaketonReturnEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.AssassinMenaceToken;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class RatonhnhaketonTokenEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("Equipment card from your graveyard");

    RatonhnhaketonTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 black Assassin creature token with menace. When you do, return target Equipment card from your graveyard to the battlefield, then attach it to that token";
    }

    private RatonhnhaketonTokenEffect(RatonhnhaketonTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public RatonhnhaketonTokenEffect copy() {
        return new RatonhnhaketonTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        AssassinMenaceToken token = new AssassinMenaceToken();
        token.putOntoBattlefield(1, game, source);
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new RatonhnhaketonReturnEffect(tokenId), false);
            ability.addTarget((Target)new TargetCardInYourGraveyard(filter));
            game.fireReflexiveTriggeredAbility(ability, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)SubType.EQUIPMENT.getPredicate());
    }
}

