/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RavingDeadDamageEffect
extends OneShotEffect {
    RavingDeadDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "that player loses half their life, rounded down";
    }

    private RavingDeadDamageEffect(RavingDeadDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public RavingDeadDamageEffect copy() {
        return new RavingDeadDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            Integer amount = player.getLife() / 2;
            if (amount > 0) {
                player.loseLife(amount.intValue(), game, source, false);
            }
            return true;
        }
        return false;
    }
}

