/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RayOfEnfeeblementEffect
extends OneShotEffect {
    RayOfEnfeeblementEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature gets -4/-1 until end of turn. If that creature is white, it gets -4/-4 until end of turn instead";
    }

    private RayOfEnfeeblementEffect(RayOfEnfeeblementEffect effect) {
        super((OneShotEffect)effect);
    }

    public RayOfEnfeeblementEffect copy() {
        return new RayOfEnfeeblementEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(-4, permanent.getColor(game).isWhite() ? -4 : -1, Duration.EndOfTurn), source);
        return true;
    }
}

