/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class RaziasPurificationEffect
extends OneShotEffect {
    RaziasPurificationEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player chooses three permanents they control, then sacrifices the rest";
    }

    private RaziasPurificationEffect(RaziasPurificationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> chosen = new ArrayList<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            TargetControlledPermanent target1 = new TargetControlledPermanent(1, 1, new FilterControlledPermanent(), true);
            if (player == null || !target1.canChoose(player.getId(), source, game)) continue;
            int chosenPermanents = 0;
            while (player.canRespond() && !target1.isChosen(game) && target1.canChoose(player.getId(), source, game) && chosenPermanents < 3) {
                player.chooseTarget(Outcome.Benefit, (Target)target1, source, game);
                for (UUID targetId : target1.getTargets()) {
                    Permanent p = game.getPermanent(targetId);
                    if (p == null) continue;
                    chosen.add(p);
                    ++chosenPermanents;
                }
                target1.clearChosen();
            }
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
            if (chosen.contains(permanent)) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }

    public RaziasPurificationEffect copy() {
        return new RaziasPurificationEffect(this);
    }
}

