/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.common.ZoneChangeTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RealityAcidTriggeredAbility
extends ZoneChangeTriggeredAbility {
    public RealityAcidTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, null, effect, "When {this} leaves the battlefield, ", optional);
    }

    private RealityAcidTriggeredAbility(RealityAcidTriggeredAbility ability) {
        super((ZoneChangeTriggeredAbility)ability);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game)) {
            Permanent attachedTo;
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(this.getSourceId());
            if (sourcePermanent != null && sourcePermanent.getAttachedTo() != null && (attachedTo = game.getPermanent(sourcePermanent.getAttachedTo())) != null) {
                for (Effect effect : this.getEffects()) {
                    effect.setTargetPointer((TargetPointer)new FixedTarget(attachedTo.getId(), attachedTo.getZoneChangeCounter(game)));
                }
            }
            return true;
        }
        return false;
    }

    public RealityAcidTriggeredAbility copy() {
        return new RealityAcidTriggeredAbility(this);
    }
}

