/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardWithDifferentNameInLibrary;
import mage.target.common.TargetOpponent;

class RealmsUnchartedEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterLandCard("land cards with different names");
    private static final FilterCard filter2 = new FilterCard("cards to put in graveyard");

    public RealmsUnchartedEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for up to four land cards with different names and reveal them. An opponent chooses two of those cards. Put the chosen cards into your graveyard and the rest into your hand. Then shuffle";
    }

    private RealmsUnchartedEffect(RealmsUnchartedEffect effect) {
        super((OneShotEffect)effect);
    }

    public RealmsUnchartedEffect copy() {
        return new RealmsUnchartedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardWithDifferentNameInLibrary targetCards = new TargetCardWithDifferentNameInLibrary(0, 4, filter);
        player.searchLibrary((TargetCardInLibrary)targetCards, source, game);
        CardsImpl cards = new CardsImpl((Collection)targetCards.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        if (cards.isEmpty()) {
            player.shuffleLibrary(source, game);
        }
        player.revealCards(source, (Cards)cards, game);
        if (cards.size() > 2) {
            TargetOpponent targetOpponent = new TargetOpponent();
            targetOpponent.withNotTarget(true);
            player.choose(this.outcome, (Target)targetOpponent, source, game);
            Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
            if (opponent != null) {
                CardsImpl cardsToKeep = new CardsImpl((Collection)cards);
                TargetCard targetDiscard = new TargetCard(2, Zone.LIBRARY, filter2);
                if (opponent.choose(Outcome.Discard, (Cards)cards, targetDiscard, source, game)) {
                    cardsToKeep.removeIf(targetDiscard.getTargets()::contains);
                    cards.removeAll((Collection)cardsToKeep);
                }
                player.moveCards((Cards)cardsToKeep, Zone.HAND, source, game);
            }
        }
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

