/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileSpellEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ReapThePastEffect
extends OneShotEffect {
    ReapThePastEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return X cards at random from your graveyard to your hand. Exile {this}.";
    }

    private ReapThePastEffect(ReapThePastEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReapThePastEffect copy() {
        return new ReapThePastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        CardsImpl cards = new CardsImpl((Collection)player.getGraveyard());
        while (cards.size() > xValue) {
            cards.remove(cards.getRandom(game));
        }
        player.moveCards((Cards)cards, Zone.HAND, source, game);
        return new ExileSpellEffect().apply(game, source);
    }
}

