/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.ElementalShamanToken;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class RebellionOfTheFlamekinEffect
extends OneShotEffect {
    RebellionOfTheFlamekinEffect() {
        super(Outcome.PutCreatureInPlay);
    }

    private RebellionOfTheFlamekinEffect(RebellionOfTheFlamekinEffect effect) {
        super((OneShotEffect)effect);
    }

    public RebellionOfTheFlamekinEffect copy() {
        return new RebellionOfTheFlamekinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ElementalShamanToken token = new ElementalShamanToken();
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        List permanents = token.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (!permanents.isEmpty() && ((Boolean)this.getValue("clash")).booleanValue()) {
            game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets(permanents, game)), source);
        }
        return true;
    }
}

