/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.TargetPermanent;

class ReckonerShakedownEffect
extends OneShotEffect {
    ReckonerShakedownEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent reveals their hand. You may choose a nonland card from it. If you do, that player discards that card. If you don't, put two +1/+1 counters on a creature or Vehicle you control";
    }

    private ReckonerShakedownEffect(ReckonerShakedownEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReckonerShakedownEffect copy() {
        return new ReckonerShakedownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        player.revealCards(source, player.getHand(), game);
        TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_A_NON_LAND);
        controller.choose(Outcome.Discard, player.getHand(), target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            player.discard(card, false, source, game);
            return true;
        }
        if (!game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_CREATURE_OR_VEHICLE, source, game, 1)) {
            return true;
        }
        TargetPermanent targetPermanent = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_CREATURE_OR_VEHICLE);
        targetPermanent.withNotTarget(true);
        controller.choose(Outcome.BoostCreature, (Target)targetPermanent, source, game);
        Permanent permanent = game.getPermanent(targetPermanent.getFirstTarget());
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(2), source, game);
        }
        return true;
    }
}

