/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ReclamationCostToAttackBlockEffect
extends PayCostToAttackBlockEffectImpl {
    ReclamationCostToAttackBlockEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, PayCostToAttackBlockEffectImpl.RestrictType.ATTACK, (Cost)new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_LAND));
        this.staticText = "Black creatures can't attack unless their controller sacrifices a land for each black creature they control that's attacking. <i>(This cost is paid as attackers are declared.)</i>";
    }

    private ReclamationCostToAttackBlockEffect(ReclamationCostToAttackBlockEffect effect) {
        super((PayCostToAttackBlockEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.getColor(game).isBlack();
    }

    public ReclamationCostToAttackBlockEffect copy() {
        return new ReclamationCostToAttackBlockEffect(this);
    }
}

