/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class RefurbishedFamiliarEffect
extends OneShotEffect {
    RefurbishedFamiliarEffect() {
        super(Outcome.DrawCard);
        this.staticText = "each opponent discards a card. For each opponent who can't, you draw a card";
    }

    private RefurbishedFamiliarEffect(RefurbishedFamiliarEffect effect) {
        super((OneShotEffect)effect);
    }

    public RefurbishedFamiliarEffect copy() {
        return new RefurbishedFamiliarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !game.getOpponents(source.getControllerId()).contains(playerId)) continue;
            int numberOfCardsToDiscard = Math.min(1, player.getHand().size());
            cards = new CardsImpl();
            TargetDiscard target = new TargetDiscard(numberOfCardsToDiscard, numberOfCardsToDiscard, StaticFilters.FILTER_CARD, playerId);
            player.chooseTarget(Outcome.Discard, (Target)target, source, game);
            cards.addAll((Collection)target.getTargets());
            cardsToDiscard.put(playerId, cards);
        }
        int toDraw = 0;
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !game.getOpponents(source.getControllerId()).contains(playerId)) continue;
            cards = (Cards)cardsToDiscard.get(playerId);
            if (cards != null && !cards.isEmpty()) {
                player.discard((Cards)cardsToDiscard.get(playerId), false, source, game);
                continue;
            }
            ++toDraw;
        }
        controller.drawCards(toDraw, source, game);
        return true;
    }
}

