/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.effects.mana.AddManaOfAnyColorEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.TriggeredManaAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;

class RegalBehemothTriggeredManaAbility
extends TriggeredManaAbility {
    RegalBehemothTriggeredManaAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new AddManaOfAnyColorEffect());
    }

    private RegalBehemothTriggeredManaAbility(RegalBehemothTriggeredManaAbility ability) {
        super((TriggeredManaAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(game.getMonarchId()) || !this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        return permanent != null && permanent.isLand(game);
    }

    public RegalBehemothTriggeredManaAbility copy() {
        return new RegalBehemothTriggeredManaAbility(this);
    }

    public String getRule() {
        return "Whenever you tap a land for mana while you're the monarch, add an additional one mana of any color.";
    }
}

