/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.cards.r.RegenerationsRestoredEffect;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;

class RegenerationsRestoredTriggeredAbility
extends TriggeredAbilityImpl {
    private static final Condition condition = new SourceHasCounterCondition(CounterType.TIME, ComparisonType.EQUAL_TO, 0);

    RegenerationsRestoredTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ScryEffect(1, false));
        this.addEffect((Effect)new GainLifeEffect(1).concatBy("and"));
        this.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new RegenerationsRestoredEffect(), condition, "Then if {this} has no time counters on it, exile it. When you do, take an extra turn after this one"));
        this.setTriggerPhrase("Whenever one or more time counters are removed from {this}, ");
    }

    private RegenerationsRestoredTriggeredAbility(RegenerationsRestoredTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTERS_REMOVED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getAmount() > 0 && event.getData().equals(CounterType.TIME.getName()) && event.getTargetId().equals(this.getSourceId());
    }

    public RegenerationsRestoredTriggeredAbility copy() {
        return new RegenerationsRestoredTriggeredAbility(this);
    }
}

