/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.TapAllEffect;
import mage.choices.ChooseFriendsAndFoes;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RegnasSanctionEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("untapped creature you control");

    RegnasSanctionEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each player, choose friend or foe. Each friend puts a +1/+1 counter on each creature they control. Each foe chooses one untapped creature they control, then taps the rest";
    }

    private RegnasSanctionEffect(RegnasSanctionEffect effect) {
        super((OneShotEffect)effect);
    }

    public RegnasSanctionEffect copy() {
        return new RegnasSanctionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ChooseFriendsAndFoes choice = new ChooseFriendsAndFoes();
        Player controller = game.getPlayer(source.getControllerId());
        if (!choice.chooseFriendOrFoe(controller, source, game)) {
            return false;
        }
        FilterCreaturePermanent filterToTap = new FilterCreaturePermanent();
        for (Player player : choice.getFoes()) {
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            if (!game.getBattlefield().contains(filter, source, game, 1) || !player.choose(Outcome.Benefit, (Target)target, source, game)) continue;
            filterToTap.add(Predicates.not((Predicate)new PermanentIdPredicate(target.getFirstTarget())));
        }
        choice.getFriends().stream().map(MageItem::getId).map(ControllerIdPredicate::new).map(Predicates::not).forEach(arg_0 -> ((FilterPermanent)filterToTap).add(arg_0));
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (!choice.getFriends().stream().map(MageItem::getId).anyMatch(arg_0 -> ((Permanent)permanent).isControlledBy(arg_0))) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        return new TapAllEffect((FilterPermanent)filterToTap).apply(game, source);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

