/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class ReignOfTerrorEffect
extends OneShotEffect {
    private static final FilterPermanent greenFilter = new FilterCreaturePermanent();
    private static final FilterPermanent whiteFilter = new FilterCreaturePermanent();

    ReignOfTerrorEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy all green creatures or all white creatures. They can't be regenerated. You lose 2 life for each creature that died this way.";
    }

    private ReignOfTerrorEffect(ReignOfTerrorEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReignOfTerrorEffect copy() {
        return new ReignOfTerrorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FilterPermanent filter = player.chooseUse(this.outcome, "Destroy all green creatures or all white creatures?", "", "Green", "White", source, game) ? greenFilter : whiteFilter;
        int died = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game).stream().mapToInt(permanent -> permanent.destroy(source, game, true) ? 1 : 0).sum();
        if (died > 0) {
            game.processAction();
            player.loseLife(2 * died, game, source, false);
            return true;
        }
        return false;
    }

    static {
        greenFilter.add((Predicate)new ColorPredicate(ObjectColor.GREEN));
        whiteFilter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

