/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;

class RejoinTheFightEffect
extends OneShotEffect {
    RejoinTheFightEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then starting with the next opponent in turn order, each opponent chooses a creature card in your graveyard that hasn't been chosen. Return each card chosen this way to the battlefield under your control";
    }

    private RejoinTheFightEffect(RejoinTheFightEffect effect) {
        super((OneShotEffect)effect);
    }

    public RejoinTheFightEffect copy() {
        return new RejoinTheFightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        if (cards.isEmpty()) {
            return false;
        }
        CardsImpl toPlay = new CardsImpl();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            if (cards.isEmpty()) break;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
            target.withNotTarget(true);
            opponent.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card == null) continue;
            game.informPlayers(opponent.getLogName() + " chooses " + card.getLogName());
            toPlay.add(card);
            cards.remove(card);
        }
        return controller.moveCards((Cards)toPlay, Zone.BATTLEFIELD, source, game);
    }
}

