/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ReluctantRoleModelEffect
extends OneShotEffect {
    ReluctantRoleModelEffect() {
        super(Outcome.Benefit);
        this.staticText = "if it had counters on it, put those counters on up to one target creature";
    }

    private ReluctantRoleModelEffect(ReluctantRoleModelEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReluctantRoleModelEffect copy() {
        return new ReluctantRoleModelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("creatureDied");
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || creature == null) {
            return false;
        }
        for (Counter counter : permanent.getCounters(game).values()) {
            creature.addCounters(counter.copy(), source, game);
        }
        return true;
    }
}

