/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class RemorselessPunishmentEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("creature or planeswalker");

    public RemorselessPunishmentEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Target opponent loses 5 life unless that player discards two cards or sacrifices a creature or planeswalker. Repeat this process once";
    }

    private RemorselessPunishmentEffect(RemorselessPunishmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public RemorselessPunishmentEffect copy() {
        return new RemorselessPunishmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent != null) {
            this.handleBaseEffect(game, source, opponent, "1st");
            this.handleBaseEffect(game, source, opponent, "2nd");
            return true;
        }
        return false;
    }

    private void handleBaseEffect(Game game, Ability source, Player opponent, String iteration) {
        TargetPermanent target;
        if (opponent.getHand().size() > 1 && opponent.chooseUse(this.outcome, "Choose your " + iteration + " punishment.", null, "Discard two cards", "Choose another option", source, game)) {
            opponent.discard(2, false, false, source, game);
            return;
        }
        if (game.getBattlefield().containsControlled((FilterPermanent)filter, opponent.getId(), source, game, 1) && opponent.chooseUse(this.outcome, "Choose your " + iteration + " punishment.", null, "Sacrifice a creature or planeswalker", "Lose 5 life", source, game) && (target = new TargetPermanent(1, 1, (FilterPermanent)filter, true)).choose(Outcome.Sacrifice, opponent.getId(), source.getId(), source, game)) {
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
            }
            return;
        }
        opponent.loseLife(5, game, source, false);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.PLANESWALKER.getPredicate()));
    }
}

