/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RendingFlameEffect
extends OneShotEffect {
    RendingFlameEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 5 damage to target creature or planeswalker. If that permanent is a Spirit, {this} also deals 2 damage to that permanent's controller";
    }

    private RendingFlameEffect(RendingFlameEffect effect) {
        super((OneShotEffect)effect);
    }

    public RendingFlameEffect copy() {
        return new RendingFlameEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.damage(5, source, game);
        if (!permanent.hasSubtype(SubType.SPIRIT, game)) {
            return true;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null) {
            player.damage(2, source, game);
        }
        return true;
    }
}

