/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.r.RendmawCreakingNestEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class RendmawCreakingNestTriggeredAbility
extends TriggeredAbilityImpl {
    RendmawCreakingNestTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new RendmawCreakingNestEffect());
        this.setTriggerPhrase("When {this} enters and whenever you play a card with two or more card types, ");
    }

    private RendmawCreakingNestTriggeredAbility(RendmawCreakingNestTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.SPELL_CAST || event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case ENTERS_THE_BATTLEFIELD: {
                return event.getTargetId().equals(this.getSourceId());
            }
            case SPELL_CAST: {
                if (!event.getPlayerId().equals(this.getControllerId())) {
                    return false;
                }
                Spell spell = game.getSpellOrLKIStack(event.getTargetId());
                return spell != null && spell.getCardType(game).size() >= 2;
            }
            case LAND_PLAYED: {
                if (!event.getPlayerId().equals(this.getControllerId())) {
                    return false;
                }
                Card card = game.getCard(event.getTargetId());
                return card != null && card.getCardType(game).size() >= 2;
            }
        }
        return false;
    }

    public RendmawCreakingNestTriggeredAbility copy() {
        return new RendmawCreakingNestTriggeredAbility(this);
    }
}

