/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class RenounceEffect
extends OneShotEffect {
    RenounceEffect() {
        super(Outcome.Neutral);
        this.staticText = "Sacrifice any number of permanents. You gain 2 life for each permanent sacrificed this way";
    }

    private RenounceEffect(RenounceEffect effect) {
        super((OneShotEffect)effect);
    }

    public RenounceEffect copy() {
        return new RenounceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = 0;
        TargetSacrifice toSacrifice = new TargetSacrifice(0, Integer.MAX_VALUE, StaticFilters.FILTER_PERMANENT);
        if (player.choose(Outcome.Sacrifice, (Target)toSacrifice, source, game)) {
            for (UUID uuid : toSacrifice.getTargets()) {
                Permanent permanent = game.getPermanent(uuid);
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
                ++amount;
            }
            player.gainLife(amount * 2, game, source);
        }
        return true;
    }
}

