/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.players.Player;

class RepeatedReverberationEffect
extends OneShotEffect {
    RepeatedReverberationEffect() {
        super(Outcome.Copy);
    }

    private RepeatedReverberationEffect(RepeatedReverberationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackAbility == null) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(stackAbility.getStackAbility().getSourceId());
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        stackAbility.createCopyOnStack(game, source, source.getControllerId(), true, 2);
        return true;
    }

    public RepeatedReverberationEffect copy() {
        return new RepeatedReverberationEffect(this);
    }
}

