/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ReplicatedRingToken;

class ReplicatingRingEffect
extends OneShotEffect {
    ReplicatingRingEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a night counter on {this}. Then if it has eight or more night counters on it, remove all of them and create eight colorless snow artifact tokens named Replicated Ring with \"{T}: Add one mana of any color.\"";
    }

    private ReplicatingRingEffect(ReplicatingRingEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReplicatingRingEffect copy() {
        return new ReplicatingRingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.addCounters(CounterType.NIGHT.createInstance(), source.getControllerId(), source, game);
        }
        if ((permanent = source.getSourcePermanentOrLKI(game)) == null || permanent.getCounters(game).getCount(CounterType.NIGHT) < 8) {
            return true;
        }
        permanent.removeAllCounters(CounterType.NIGHT.getName(), source, game);
        new ReplicatedRingToken().putOntoBattlefield(8, game, source, source.getControllerId());
        return true;
    }
}

