/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ResearchEffect
extends OneShotEffect {
    ResearchEffect() {
        super(Outcome.Benefit);
        this.staticText = "Shuffle up to four cards you own from outside the game into your library";
    }

    private ResearchEffect(ResearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public ResearchEffect copy() {
        return new ResearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.chooseUse(Outcome.Benefit, this.staticText + "?", source, game)) {
                Cards cards = controller.getSideboard();
                if (cards.isEmpty()) {
                    game.informPlayer(controller, "You have no cards outside the game.");
                    return true;
                }
                TargetCard target = new TargetCard(0, 4, Zone.OUTSIDE, new FilterCard("cards you own from outside the game"));
                target.withNotTarget(true);
                if (controller.choose(Outcome.Benefit, controller.getSideboard(), target, source, game)) {
                    controller.shuffleCardsToLibrary((Cards)new CardsImpl((Collection)target.getTargets()), game, source);
                }
            }
            return true;
        }
        return false;
    }
}

