/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ResoluteStrikeEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.EQUIPMENT, "Equipment you control");

    ResoluteStrikeEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's a Warrior, you may attach an Equipment you control to it";
    }

    private ResoluteStrikeEffect(ResoluteStrikeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ResoluteStrikeEffect copy() {
        return new ResoluteStrikeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player == null || permanent == null || !permanent.hasSubtype(SubType.WARRIOR, game) || game.getBattlefield().count(filter, source.getControllerId(), source, game) == 0 || !player.chooseUse(this.outcome, "Attach an equipment you control?", source, game)) {
            return false;
        }
        TargetPermanent targetPermanent = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)targetPermanent, source, game);
        return permanent.addAttachment(targetPermanent.getFirstTarget(), source, game);
    }
}

