/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ResourcefulDefenseLeaveEffect
extends OneShotEffect {
    ResourcefulDefenseLeaveEffect() {
        super(Outcome.Benefit);
        this.staticText = "put those counters on target permanent you control";
    }

    private ResourcefulDefenseLeaveEffect(ResourcefulDefenseLeaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public ResourcefulDefenseLeaveEffect copy() {
        return new ResourcefulDefenseLeaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Counters counters = (Counters)this.getValue("counters");
        counters.values().stream().filter(counter -> counter.getCount() > 0).forEach(counter -> permanent.addCounters(counter, source.getControllerId(), source, game));
        return true;
    }
}

