/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class RetrieverPhoenixEffect
extends ReplacementEffectImpl {
    RetrieverPhoenixEffect() {
        super(Duration.WhileInGraveyard, Outcome.PutCreatureInPlay);
        this.staticText = "as long as this card is in your graveyard, if you would learn, you may instead return this card to the battlefield";
    }

    private RetrieverPhoenixEffect(RetrieverPhoenixEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RetrieverPhoenixEffect copy() {
        return new RetrieverPhoenixEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card = source.getSourceCardIfItStillExists(game);
        Player player = game.getPlayer(source.getControllerId());
        return card != null && player != null && player.chooseUse(this.outcome, "Return " + card.getName() + " to the battlefield instead of learning?", source, game) && player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LEARN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }
}

