/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ReturnToDustExileEffect
extends OneShotEffect {
    ReturnToDustExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile target artifact or enchantment";
    }

    private ReturnToDustExileEffect(ReturnToDustExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReturnToDustExileEffect copy() {
        return new ReturnToDustExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent firstTarget = game.getPermanent(source.getFirstTarget());
        if (firstTarget != null) {
            controller.moveCards((Card)firstTarget, Zone.EXILED, source, game);
            return true;
        }
        return false;
    }
}

