/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ElfWarriorToken;
import mage.players.Player;
import mage.util.CardUtil;

class ReturnUponTheTideEffect
extends OneShotEffect {
    ReturnUponTheTideEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target creature card from your graveyard to the battlefield. If it's an Elf, create two 1/1 green Elf Warrior creature tokens.";
    }

    private ReturnUponTheTideEffect(ReturnUponTheTideEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReturnUponTheTideEffect copy() {
        return new ReturnUponTheTideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        if (permanent.hasSubtype(SubType.ELF, game)) {
            new ElfWarriorToken().putOntoBattlefield(2, game, source, player.getId());
        }
        return true;
    }
}

