/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class RevealingEyeEffect
extends OneShotEffect {
    RevealingEyeEffect() {
        super(Outcome.Discard);
        this.staticText = "target opponent reveals their hand. You may choose a nonland card from it. If you do, that player discards that card, then draws a card";
    }

    private RevealingEyeEffect(RevealingEyeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RevealingEyeEffect copy() {
        return new RevealingEyeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        if (opponent.getHand().count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game) < 1) {
            return true;
        }
        TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        controller.choose(this.outcome, opponent.getHand(), target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        opponent.discard(card, false, source, game);
        opponent.drawCards(1, source, game);
        return true;
    }
}

