/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ReversalOfFortuneEffect
extends OneShotEffect {
    ReversalOfFortuneEffect() {
        super(Outcome.Copy);
        this.staticText = "Target opponent reveals their hand. You may copy an instant or sorcery card in it. If you do, you may cast the copy without paying its mana cost";
    }

    private ReversalOfFortuneEffect(ReversalOfFortuneEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReversalOfFortuneEffect copy() {
        return new ReversalOfFortuneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller != null && opponent != null) {
            CardsImpl revealedCards = new CardsImpl();
            revealedCards.addAll((Collection)opponent.getHand());
            opponent.revealCards("Reveal", (Cards)revealedCards, game);
            TargetCard target = new TargetCard(0, 1, Zone.HAND, (FilterCard)new FilterInstantOrSorceryCard());
            if (controller.choose(Outcome.PlayForFree, (Cards)revealedCards, target, source, game)) {
                Card card = revealedCards.get(target.getFirstTarget(), game);
                if (card != null) {
                    Card copiedCard = game.copyCard(card, source, source.getControllerId());
                    if (controller.chooseUse(Outcome.PlayForFree, "Cast the copied card without paying mana cost?", source, game)) {
                        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
                        controller.cast(controller.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
                        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

