/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ReverseTheSandsEffect
extends OneShotEffect {
    ReverseTheSandsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Redistribute any number of players' life totals";
    }

    private ReverseTheSandsEffect(ReverseTheSandsEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReverseTheSandsEffect copy() {
        return new ReverseTheSandsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            ChoiceImpl lifeChoice = new ChoiceImpl(true);
            LinkedHashSet<String> choices = new LinkedHashSet<String>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                choices.add(Integer.toString(player.getLife()) + " life of " + player.getLogName());
            }
            lifeChoice.setChoices(choices);
            for (UUID playersId : game.getState().getPlayersInRange(controller.getId(), game)) {
                int index;
                String selectedChoice;
                player = game.getPlayer(playersId);
                if (player == null) continue;
                if (choices.size() > 1) {
                    lifeChoice.setMessage("Which players life should get player " + player.getLogName());
                    if (!controller.choose(Outcome.Detriment, (Choice)lifeChoice, game)) {
                        return false;
                    }
                    selectedChoice = lifeChoice.getChoice();
                } else {
                    selectedChoice = (String)choices.iterator().next();
                }
                if ((index = selectedChoice.indexOf(32)) <= 0) continue;
                String lifeString = selectedChoice.substring(0, index);
                int life = Integer.parseInt(lifeString);
                player.setLife(life, game, source);
                choices.remove(selectedChoice);
                game.informPlayers("Player " + player.getLogName() + " life set to " + life);
            }
        }
        return false;
    }
}

