/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class RevivingVaporsEffect
extends OneShotEffect {
    RevivingVaporsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top three cards of your library and put one of them into your hand. You gain life equal to that card's mana value. Put all other cards revealed this way into your graveyard";
    }

    private RevivingVaporsEffect(RevivingVaporsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 3));
        if (!cards.isEmpty()) {
            controller.revealCards(sourceObject.getName(), (Cards)cards, game);
            Card card = null;
            if (cards.size() == 1) {
                card = cards.getRandom(game);
            } else {
                TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put into your hand"));
                target.withNotTarget(true);
                target.setRequired(true);
                if (controller.choose(Outcome.DrawCard, (Cards)cards, target, source, game)) {
                    card = cards.get(target.getFirstTarget(), game);
                }
            }
            if (card != null) {
                cards.remove(card);
                controller.moveCards(card, Zone.HAND, source, game);
                controller.gainLife(card.getManaValue(), game, source);
            }
            controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        }
        return true;
    }

    public RevivingVaporsEffect copy() {
        return new RevivingVaporsEffect(this);
    }
}

