/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ReyEffect
extends OneShotEffect {
    ReyEffect() {
        super(Outcome.Detriment);
        this.staticText = "reveal the top card of target player's library. You gain life equal to that card's mana value";
    }

    private ReyEffect(ReyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReyEffect copy() {
        return new ReyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (targetPlayer != null && controller != null) {
            if (targetPlayer.getLibrary().hasCards()) {
                Card topCard = targetPlayer.getLibrary().getFromTop(game);
                CardsImpl reveal = new CardsImpl();
                reveal.add(topCard);
                targetPlayer.revealCards(source, (Cards)reveal, game);
                if (topCard != null) {
                    controller.gainLife(topCard.getManaValue(), game, source);
                }
            }
            return true;
        }
        return false;
    }
}

